# @twitch/flexo/TestMyAgents

This is intended to be used in conjunction with Flexo [`testMyAgents` Flexo CI library function][testMyAgents].  The CDK here will create a Cloudwatch alarm and configure it to send notifications to PagerDuty.

You can find additional information about using the [`testMyAgents` Flexo CI library function in the wiki][wiki].

### Example for creating a new stack to monitor your Flexo CI agents

```typescript
import * as cdk from '@aws-cdk/core';
import * as flexo from '@twitch/flexo';

export class TestMyAgentsExampleStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: cdk.StackProps) {
    super(scope, id, props);
    new flexo.TestMyAgents(this, 'flexo', {
      pagerDutyErrorsIntegrationUrl: 'https://events.pagerduty.com/integration/<PD INTEGRATION KEY>/enqueue'
    });
  }
}
```

[An example git project with documentation](https://git-aws.internal.justin.tv/flexo/testMyAgents-example)

[testMyAgents]: https://git-aws.internal.justin.tv/flexo/flexo-libs/blob/master/vars/testMyAgents.groovy
[wiki]: https://wiki.twitch.com/display/PS/Flexo+Jenkins+Shared+Libraries#FlexoJenkinsSharedLibraries-MonitoringyourFlexoCIAgents
