// import { SynthUtils} from '@aws-cdk/assert';
import { expect as expectCDK, haveResource, haveResourceLike, SynthUtils } from '@aws-cdk/assert';
import * as ec2 from '@aws-cdk/aws-ec2';
// import '@aws-cdk/assert';
import * as cdk from '@aws-cdk/core';
import * as flexo from '../../lib/';

test('Staging - Create Flexo ECS Instances', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, "StagingTestECSStack", {});

    const vpc = new ec2.Vpc(stack, 'VPC');

    new flexo.JenkinsSlavesEcs(stack, 'StagingFlexoECS', {
        jenkinsEnvironment: 'staging',
        ecsClusterName: 'one-crazy-cluster',
        vpc,
        instanceType: ec2.InstanceType.of(ec2.InstanceClass.T2, ec2.InstanceSize.MICRO),
        machineImage: new ec2.AmazonLinuxImage(),
        maxCapacity: 4,
        logGroupName: '/JenkinsAgents',
        dashboardName: 'JenkinsECSAgents'
    });

    expectCDK(stack).to(haveResource("AWS::AutoScaling::AutoScalingGroup", {
        MaxSize: "4"
    }));
    expectCDK(stack).to(haveResourceLike("AWS::AutoScaling::LaunchConfiguration", {
        InstanceType: "t2.micro"
    }));
    expectCDK(stack).to(haveResourceLike("AWS::EC2::VPC"));
    expectCDK(stack).to(haveResourceLike("AWS::EC2::RouteTable"));
    expectCDK(stack).to(haveResourceLike("AWS::IAM::Role", {
        AssumeRolePolicyDocument: {
            Statement: [
                {
                    Action: "sts:AssumeRole",
                    Effect: "Allow",
                    Principal: {
                        AWS: "arn:aws:iam::688816252578:role/StagingJenkinsStack-JenkinsMasterRole479E481F-1L6S5CSQWX9JD"
                    }
                }
            ],
            Version: "2012-10-17"
        },
    }));
    expectCDK(stack).to(haveResourceLike("AWS::IAM::Policy"));
    expectCDK(stack).to(haveResourceLike("AWS::ECS::Cluster"));
    expectCDK(stack).to(haveResourceLike("AWS::EC2::SecurityGroup"));
    expectCDK(stack).to(haveResourceLike("AWS::Logs::LogGroup"));
    expectCDK(stack).to(haveResourceLike("AWS::CloudWatch::Dashboard"));
    expectCDK(stack).to(haveResourceLike("AWS::Route53::HostedZone", {
        Name: 'staging.jenkins.xarth.tv.'
    }));
    expectCDK(stack).to(haveResource("AWS::EC2::VPCEndpoint", {
        ServiceName: "com.amazonaws.vpce.us-west-2.vpce-svc-09895fee8207ff691"
    }));

    expect(SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});

test('Production - Create Flexo ECS Instances', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, "ProductionTestECSStack", {});

    const vpc = new ec2.Vpc(stack, 'VPC');

    new flexo.JenkinsSlavesEcs(stack, 'ProductionFlexoECS', {
        vpc,
        instanceType: ec2.InstanceType.of(ec2.InstanceClass.T2, ec2.InstanceSize.MICRO),
        machineImage: new ec2.AmazonLinuxImage(),
        maxCapacity: 4,
        logGroupName: '/JenkinsAgents',
        dashboardName: 'JenkinsECSAgents'
    });

    expectCDK(stack).to(haveResource("AWS::AutoScaling::AutoScalingGroup", {
        MaxSize: "4"
    }));
    expectCDK(stack).to(haveResourceLike("AWS::AutoScaling::LaunchConfiguration", {
        InstanceType: "t2.micro"
    }));
    expectCDK(stack).to(haveResourceLike("AWS::EC2::VPC"));
    expectCDK(stack).to(haveResourceLike("AWS::EC2::RouteTable"));

    // neeCDKd to add s(hmething here for production
    expectCDK(stack).to(haveResourceLike("AWS::IAM::Role"));
    expectCDK(stack).to(haveResourceLike("AWS::IAM::Policy"));
    expectCDK(stack).to(haveResourceLike("AWS::ECS::Cluster"));
    expectCDK(stack).to(haveResourceLike("AWS::EC2::SecurityGroup"));
    expectCDK(stack).to(haveResourceLike("AWS::Logs::LogGroup"));
    expectCDK(stack).to(haveResourceLike("AWS::CloudWatch::Dashboard"));
    expectCDK(stack).to(haveResourceLike("AWS::Route53::HostedZone", {
        Name: 'jenkins.xarth.tv.'
    }));
    // need to add something here for production
    expectCDK(stack).to(haveResource("AWS::EC2::VPCEndpoint"));

    expect(SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
