import { expect as expectCDK, haveResource, SynthUtils } from '@aws-cdk/assert';
import * as cdk from '@aws-cdk/core';
import * as flexo from '../../lib/';

test('TestMyAgentsStack defaults', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, "TestStackDefaults");
    new flexo.TestMyAgents(stack, 'TestMyAgentsStackDefault', {
        env: {
            account: '123456789',
            region: 'us-west-2'
        },
        pagerDutyErrorsIntegrationUrl: 'https://nothere.com'
    });

    expectCDK(stack).to(haveResource("AWS::SNS::Subscription", {
        Endpoint: 'https://nothere.com'
    }));
    expectCDK(stack).to(haveResource("AWS::CloudWatch::Alarm", {
        MetricName: 'failures',
        Namespace: 'JenkinsAgents',
        EvaluationPeriods: 2,
        Threshold: 2
    }));
    expectCDK(stack).to(haveResource("AWS::CloudWatch::Dashboard", {
        DashboardName: 'Jenkins_Agent_Failures'
    }));

    expect(SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});

test('TestMyAgentsStack all options', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, "TestStackAllOptions");
    new flexo.TestMyAgents(stack, 'TestMyAgentsStackAllOptions', {
        env: {
            account: '123456789',
            region: 'us-west-2'
        },
        cloudwatchNamespace: 'namespace',
        snsErrorTopic: 'topic',
        alarmThreshold: 4,
        alarmPeriodInMinutes: 5,
        alarmEvaluationPeriods: 3,
        pagerDutyErrorsIntegrationUrl: 'https://nothere.com',
        dashboardProps: {
          dashboardName: 'My_Custom_Name'
        }
    });

    expectCDK(stack).to(haveResource("AWS::SNS::Subscription", {
        Endpoint: 'https://nothere.com'
    }));
    expectCDK(stack).to(haveResource("AWS::CloudWatch::Alarm", {
        MetricName: 'failures',
        Namespace: 'namespace',
        EvaluationPeriods: 3,
        Threshold: 4,
        Period: 300
    }));
    expectCDK(stack).to(haveResource("AWS::CloudWatch::Dashboard", {
        DashboardName: 'My_Custom_Name'
    }));

    expect(SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
