#!/usr/bin/env groovy
package com.twitch.ipdev.flexo

abstract class FlexoPipelineBase implements Serializable {
  protected Script script
  protected Map args
  protected env
  protected Map<String,String> org_config = [:]

  protected Map buildStages = [:]
  protected Map deployStages = [:]

  public String agentLabel
  public Boolean reportStatus = true

  FlexoPipelineBase (Script script, Map args, env) {
    this.script = script
    this.args = args
    this.env = env

    this.agentLabel = this.args.get('agentLabel') ?: this.agentLabel

    // explicit check for null since false is a valid value
    this.reportStatus = this.args.get('reportStatus') == null ? this.reportStatus : this.args.get('reportStatus')
  }

  public init() {
    script.echo "This job is based on the ${this.class.getSimpleName()} Flexo Pipeline"

    // flexo_org_config is an optional user-defined function that can exist and is called automatically here.
    // we call the function and ignore the error if it doesn't exist. This intended to be used so teams can have
    // a single place to define common variables, etc.
    try {
      script.echo "Checking for flexo_org_config"
      this.org_config = script.flexo_org_config()
    } catch (Exception e) {
      script.echo "No flexo_org_config found"
    }
    buildStages['INIT'] = new FlexoPipelineStage(script, FlexoStage.INIT, reportStatus, {
      this.validate()
    }, env);
  }

  public validate() {
    script.echo 'Flexo Pipeline validation complete'
  }

  // This actually runs the pipeline stages.
  def run() {
    script.node(agentLabel) {
      script.flexo.checkout()
      buildStages.eachWithIndex { key, value, i ->
        value.run()
      }
    }

    deployStages.eachWithIndex { key, value, i ->
      if(value.type == FlexoStage.DEPLOY_APPROVAL) {
        value.run()
      } else {
        script.node(agentLabel) {
          script.flexo.checkout()
          value.run()
        }
      }
    }
  }
}
