package groovy

import com.twitch.ipdev.flexo.pipelines.Generic
import groovy.libs.FlexoPipelineTest
import org.junit.*

import static groovy.test.GroovyAssert.assertEquals
import static groovy.test.GroovyAssert.assertNotNull
import static groovy.test.GroovyAssert.assertNull

class FlexoGenericPipelineTest extends FlexoPipelineTest {
    Script flexo

    Generic defaultPipeline
    Generic customPipeline1
    Generic customPipeline2

    @Before
    void setUp() {
        super.setUp()
        flexo = loadScript("vars/flexo.groovy")

        def env = binding.getVariable("env")

        defaultPipeline = new Generic(flexo, [:], env)
        customPipeline1 = new Generic(flexo, [ agentLabel: 'myAgents', reportStatus: true ], env)
        customPipeline2 = new Generic(flexo, [ agentLabel: 'myOtherAgents', reportStatus: false ], env)
    }

    @Test
    void testSettingAgentLabelField() {
        assertNull defaultPipeline.agentLabel
        assert customPipeline1.agentLabel == 'myAgents'
    }

    @Test
    void testSettingReportStatusField() {
        // default to true
        assert defaultPipeline.reportStatus
        // set to true
        assert customPipeline1.reportStatus
        // set to false
        assert !customPipeline2.reportStatus
    }

    @Test
    void testDefaultInitializationResults() {
        defaultPipeline.init()

        // flexo_org_config triggered exactly once
        assertEquals methodCallCount('flexo_org_config'), 1
        // no flexo_org_config should have been found
        assert methodCalledWithArgs('echo', "No flexo_org_config found")

        // we should now have a single INIT build stage
        assert defaultPipeline.buildStages.size() == 1
        assertNotNull defaultPipeline.buildStages['INIT']
        // our INIT stage should have the same reportStatus value as our pipeline
        assertEquals defaultPipeline.buildStages['INIT'].reportStatus, defaultPipeline.reportStatus
    }

    @Test
    void testDefaultValidationResults() {
        defaultPipeline.validate()
        assert methodCalledWithArgs('echo', "Flexo Pipeline validation complete")
    }
}
