import com.twitch.ipdev.flexo.PipelineTemplate

enum pipelineType { GENERIC, CSHARP }

// simply calling `flexo` in a Jenkinsfile is not valid
def call(Map args) {
  node {
    stage('Not Implemented') {
      echo 'flexo() is not implemented. You should be using flexo.pipeline()'
    }
  }
}

// flexo.pipeline called in Jenkinsfile
def pipeline(Map args = [:], Closure JenkinsfileInit) {
  properties([
      buildDiscarder(logRotator(daysToKeepStr: '30', numToKeepStr: '20', artifactNumToKeepStr: '20')),
      disableConcurrentBuilds()
    ])

  // Determine the template type to use from the `template` argument and instantiate an instance of it
  def template = args.get('template') ?: 'GENERIC'
  def pipelineTemplate = template as PipelineTemplate
  def flexoPipeline = pipelineTemplate.klass.newInstance(this, args, env)

  // Setting the resolve strategy here lets us use standard Jenkinsfile syntax in the pipeline stages
  // for things such as `echo`, `sh`, etc, rather than using `script.echo`, `script.sh`
  // JenkinsfileInit is a closure that is optionally passed from the user Jenkinsfile.
  JenkinsfileInit.resolveStrategy = Closure.DELEGATE_FIRST
  JenkinsfileInit.delegate = flexoPipeline
  JenkinsfileInit()

  // This begins the call to code for the specific template. For example, looks in
  // src/com/twitch/ipdev/flexo/pipelines/DotnetcoreECS.groovy for the following init and run functions
  // init will populate 2 map variables with Jenkinsfile stages to be run later by the run() function
  flexoPipeline.init()

  flexoPipeline.run()
}

// checkout
def checkout() {
  // simple function to automatically add checkout results to env vars
  def scmVars = checkout(scm)
  scmVars.each { k,v ->
    env[k] = v
  }
}
