def call(Map args=[:]) {
  args['state'] = args.state
  args['targetUrl'] = "${currentBuild.absoluteUrl}"
  args['context'] = args['context'] ? args['context'] : STAGE_NAME

  if(args.githubApiEndpoint){
    args['githubApiEndpoint'] = args.githubApiEndpoint
  } else {
    def scmInfo = scm.getUserRemoteConfigs()[0].getUrl().tokenize('/')
    args['githubApiEndpoint'] = "https://git-aws.internal.justin.tv/api/v3/repos/${scmInfo[-2]}/${scmInfo[-1].replaceAll('.git','')}/statuses/${env.GIT_COMMIT}"
  }

  echo "setBuildStatusCommon: ${args['context']} - ${args['state']}"

  withCredentials([
    usernamePassword(credentialsId: args.credentialsId, usernameVariable: 'GHE_USER', passwordVariable: 'GHE_PAT'),
  ]) {
    args["gheUser"] = GHE_USER
    args["ghePAT"] = GHE_PAT
    new com.twitch.ipdev.SetBuildStatus(args).setStatus()
  }
}
