def call(Map args=[:]) {
  properties([
    buildDiscarder(logRotator(daysToKeepStr: '30')),
    disableConcurrentBuilds(),
    pipelineTriggers([cron('H/15 * * * *')])
  ])

  tests = [:]
  String label = args.get('agentLabel')
  if (label == null) {
    error 'You must set a valid label for the testMyAgents function'
  }
  nodes = nodesByLabel(label)
  for ( thisNode in nodes ) {
    tests[thisNode] = {
      node(thisNode) {
        try {
          stage(label + 'Checkout') {
            checkout scm
          }
          stage(label + ' tests') {
            agentTests = new com.twitch.ipdev.AgentTests()
            agentTestConfig = loadAgentTestConfig(args.get('testFile', 'tests.yaml'))
            agentTests.runAgentTests(this, agentTestConfig, args)
          }
        } finally {
          junit 'tests/*.xml'
        }
      }
    }
  }
  parallel tests
}
