def call(Map args=[:], Closure body) {
  def AWS_CONFIG_CONTENTS = """[default]
        |role_arn = ${args.role_arn ?: 'arn:aws:iam::' + args.roleAccount + ':role/' + args.role}
        |role_session_name = ${args.roleSessionName ?: 'flexo' + System.currentTimeMillis() / 1000L}
        |credential_source = ${args.credential_source ?: 'Ec2InstanceMetadata'}
        |${args.output ? 'output = ' + args.output : ''}
        |${args.region ? 'region = ' + args.region : ''}
        |${args.duration ? 'duration_seconds = ' + args.duration : ''}
        |${args.externalId ? 'external_id = ' + args.externalId : ''}
        """.stripMargin()

  withEnv(["AWS_CONFIG_FILE=${env.WORKSPACE}/.flexo/.aws/config"]) {
    sh "#!/bin/bash -e\nmkdir -p \$(dirname \${AWS_CONFIG_FILE}) && echo \"${AWS_CONFIG_CONTENTS}\" > \${AWS_CONFIG_FILE}"
    body()
  }
}
