# Global mapping of shorthand codes to AWS regions
# frozen_string_literal: true

AWS_REGIONS = {
  nrt: 'ap-northeast-1',
  icn: 'ap-northeast-2',
  bom: 'ap-south-1',
  sin: 'ap-southeast-1',
  syd: 'ap-southeast-2',
  yul: 'ca-central-1',
  fra: 'eu-central-1',
  dub: 'eu-west-1',
  lhr: 'eu-west-2',
  gru: 'sa-east-1',
  iad: 'us-east-1',
  cle: 'us-east-2',
  sjc: 'us-west-1',
  pdx: 'us-west-2'
}.freeze

# common environment variables
ASPNETCORE_ENVIRONMENT             = ENV['ASPNETCORE_ENVIRONMENT'].freeze
AWS_ECR_URL                        = ENV['AWS_ECR_URL'].freeze
CLUSTER_NAME                       = ENV['CLUSTER_NAME'].freeze
DEPLOY_ASSUME_ROLE                 = ENV['DEPLOY_ASSUME_ROLE'].freeze
DEPLOY_AWS_ACCOUNT                 = ENV['DEPLOY_AWS_ACCOUNT'].freeze
DEPLOY_CLOUDWATCH_REGION           = AWS_REGIONS[ENV['DEPLOY_CLOUDWATCH_ENV'].to_sym].freeze
DEPLOY_ENV                         = ENV['DEPLOY_ENV'].split(',').map(&:strip).map(&:to_sym).freeze
DESIRED_COUNT                      = ENV['DESIRED_COUNT'].freeze
IMAGE_VERSION                      = ENV['IMAGE_VERSION'].freeze
SERVICE_NAME                       = ENV['SERVICE_NAME'].freeze
TARGET_ENV                         = (ENV['TARGET_ENV'] || ENV['ASPNETCORE_ENVIRONMENT'].downcase).freeze
TASK_FAMILY                        = ENV['TASK_FAMILY'].freeze
TASK_ROLE                          = ENV['TASK_ROLE'].freeze
TEAMCITY_PROJECT_NAME              = ENV['IMAGE_NAME'].freeze

# monitoring config
Monitoring__AlertHandler          = ENV['Monitoring__AlertHandler'].freeze
Monitoring__HeartbeatHandler      = ENV['Monitoring__HeartbeatHandler'].freeze
Monitoring__KeepalivePagerTeam    = ENV['Monitoring__KeepalivePagerTeam'].freeze
Monitoring__MetricHandlers        = ENV['Monitoring__MetricHandlers'].freeze
Monitoring__SensuSnsTopic         = ENV['Monitoring__SensuSnsTopic'].freeze

# Audit Log Service environment variables
Arcana__DefaultBucket                = ENV['Arcana__DefaultBucket'].freeze
Arcana__DefaultService               = ENV['Arcana__DefaultService'].freeze
AuditLog__S3__BucketName             = ENV['AuditLog__S3__BucketName'].freeze
AuditLog__SNS__TopicArn              = ENV['AuditLog__SNS__TopicArn'].freeze
Cors__Origins                        = ENV['Cors__Origins'].freeze
Elastic__Host                        = ENV['Elastic__Host'].freeze
Elastic__IndexNameOverride           = ENV['Elastic__IndexNameOverride'].freeze
Elastic__TimeSeriesType              = ENV['Elastic__TimeSeriesType'].freeze
Elastic__ShardCountOverride          = ENV['Elastic__ShardCountOverride'].freeze
Elastic__ReplicaCountOverride        = ENV['Elastic__ReplicaCountOverride'].freeze
Logging__Service__Url                = ENV['Logging__Service__Url'].freeze
Sqs__WorkerConfiguration__AuditMessages__QueueUrl         = ENV['Sqs__WorkerConfiguration__AuditMessages__QueueUrl'].freeze
Sqs__WorkerConfiguration__AuditMessages__SubscriptionConfirmationTopicArnsWhitelist = ENV['Sqs__WorkerConfiguration__AuditMessages__SubscriptionConfirmationTopicArnsWhitelist'].freeze
Sqs__WorkerConfiguration__AuditMessages__NumberOfWorkers = ENV['Sqs__WorkerConfiguration__AuditMessages__NumberOfWorkers'].freeze