﻿using System;
using Elasticsearch.Net;
using FluentAssertions;
using Nest;
using Twitch.AuditLogService.ChangeLog.Models;
using Twitch.ElasticSearch.Extensions;
using Twitch.ElasticSearch.Search;
using Xunit;

namespace Twitch.AuditLogService.Tests.ChangeLog.Models
{
    [Trait("Category", "Unit")]
    public class ChangeLogSearchTests
    {
        [Fact]
        public void GetQuery_ModifiesSearchDescriptor()
        {
            // Arrange
            var changeLogSearch = new ChangeLogSearch
            {
                Filter = new ChangeLogSearchFilter
                {
                    
                    Categories = new[] { "TestCategory1", "TestCategory2" },
                    Source = new[] { "TestSource" },
                    Username = new[] { "TestName" }
                },
                Query = new ChangeLogSearchQuery
                {
                    Command = "TestCommand",
                }
            };
            QueryContainerDescriptor<ChangeLogElasticEntry> builder =
                new QueryContainerDescriptor<ChangeLogElasticEntry>();

            // Act
            var result = changeLogSearch.GetQuery(builder);

            // Assert
            var test = new ElasticClient().Serializer.SerializeToString(result);
            test.Should().ContainAll("categories", "TestCategory1", "TestCategory2",
                "source", "TestSource",
                "username", "TestName",
                "command", "TestCommand");
        }

        [Fact]
        public void ScrollingSearchFilter_ModifiesSearchDescriptor()
        {
            // Arrange
            var now = DateTimeOffset.UtcNow.ToUnixTimeMilliseconds();
            var changeLogSearch = new ChangeLogSearch
            {
                SearchFilter = new ScrollingSearchFilter
                {
                    Id = "testId",
                    Timestamp = now
                }
            };

            // Act
            var result = new SearchDescriptor<ChangeLogElasticEntry>()
                .ApplyScrollingSearchFilter(changeLogSearch.SearchFilter, x => x.Timestamp, x => x.Id);

            // Assert
            var test = new ElasticClient().Serializer.SerializeToString(result);
            test.Should().ContainAll("testId", now.ToString());
        }
    }
}