﻿using System.Net;
using System.Threading.Tasks;
using FluentAssertions;
using Twitch.AuditLogService.Web;
using Twitch.Shared.Test;
using Xunit;

namespace Twitch.AuditLogService.Tests.Integration.Controllers
{
    [Trait("Category", "Integration")]
    public class HealthCheckControllerTests : ControllerTestBase<Startup>
    {
        public HealthCheckControllerTests(LocalWebApplicationFixture fixture) : base(fixture)
        {
        }

        [Fact]
        public async Task GetHealthRunning()
        {
            // Arrange & Act
            var response = await Client.GetAsync("/debug/running");

            // Assert
            response.StatusCode.Should().Be(HttpStatusCode.OK);
        }
    }
}