﻿using System.Net;
using System.Threading.Tasks;
using FluentAssertions;
using Twitch.AuditLogService.Web;
using Twitch.Shared.Test;
using Xunit;

namespace Twitch.AuditLogService.Tests.Integration.Controllers
{
    [Trait("Category", "Integration")]
    public class MainControllerTests : ControllerTestBase<Startup>
    {
        public MainControllerTests(LocalWebApplicationFixture fixture) : base(fixture)
        {
        }

        [Fact]
        public async Task Index()
        {
            // Arrange & Act
            var response = await Client.GetAsync(string.Empty);

            // Assert
            response.StatusCode.Should().Be(HttpStatusCode.OK);
            (await response.Content.ReadAsStringAsync()).Should().Be("Audit Log Service");
        }
    }
}
