﻿using System;
using Nest;
using Elasticsearch.Net;
using FluentAssertions;
using Twitch.AuditLogService.Models;
using Twitch.ElasticSearch.Extensions;
using Twitch.ElasticSearch.Search;
using Xunit;

namespace Twitch.AuditLogService.Tests.Models
{
    [Trait("Category", "Unit")]
    public class AuditLogSearchTests
    {
        [Fact]
        public void GetQuery_ModifiesSearchDescriptor()
        {
            // Arrange
            var auditLogSearch = new AuditLogSearch
            {
                Filter = new AuditLogSearchFilter { 
                    ActionType = new[] {"TestType1", "TestType2"},
                    TokenId = new[] { "TestToken" },
                    Name = new[] { "TestName" }
                },
                Query = new AuditLogSearchQuery { 
                    Title = "TestTitle",
                }
            };
            QueryContainerDescriptor<AuditLogElasticEntry> builder =
                new QueryContainerDescriptor<AuditLogElasticEntry>();

            // Act
            var result = auditLogSearch.GetQuery(builder);

            // Assert
            var test = new ElasticClient().Serializer.SerializeToString(result);
            test.Should().ContainAll("actionType", "TestType1", "TestType2", 
                "title", "TestTitle", 
                "name", "TestName",
                "TestToken");
        }

        [Fact]
        public void ScrollingSearchFilter_ModifiesSearchDescriptor()
        {
            // Arrange
            var now = DateTimeOffset.UtcNow.ToUnixTimeMilliseconds();
            var auditLogSearch = new AuditLogSearch
            {
                SearchFilter = new ScrollingSearchFilter
                {
                    Id = "testId",
                    Timestamp = now
                }
            };

            // Act
            var result = new SearchDescriptor<AuditLogElasticEntry>()
                .ApplyScrollingSearchFilter(auditLogSearch.SearchFilter, x => x.Created, x => x.Id);

            // Assert
            var test = new ElasticClient().Serializer.SerializeToString(result);
            test.Should().ContainAll("testId", now.ToString());
        }
    }
}
