﻿using Microsoft.AspNetCore.Mvc;

namespace Twitch.AuditLogService.Web.Controllers
{
    /// <summary>
    /// Provides endpoints for evaluating the overall health of the service.
    /// </summary>
    [Route("debug")]
    public class HealthCheckController : ControllerBase
    {
        /// <summary>
        /// Automatic health check endpoint that will terminate the instance on a non-2xx response.
        /// </summary>
        [Route("running")]
        [HttpGet]
        public IActionResult CheckHealth()
        {
            return Ok();
        }
    }
}