﻿using Microsoft.AspNetCore.Mvc;
using Twitch.AuditLogService.Web.Util;

namespace Twitch.AuditLogService.Web.Model
{
    public class ChangeLogLegacySearchOptions
    {
        [FromQuery(Name = "hours_ago")]
        public int HoursAgo { get; set; }

        [FromQuery(Name = "until")]
        public int Until { get; set; } = -1;

        [FromQuery(Name = "criticality")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string Criticality { get; set; }

        [FromQuery(Name = "category")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string Category { get; set; }

        [FromQuery(Name = "command")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string Command { get; set; }

        [FromQuery(Name = "description")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string Description { get; set; }

        [FromQuery(Name = "additional_data")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string AdditionalData { get; set; }

        [FromQuery(Name = "username")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string Username { get; set; }

        [FromQuery(Name = "target")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string Target { get; set; }

        [FromQuery(Name = "source")]
        [ModelBinder(typeof(NullStringValueBinder))]
        public string Source { get; set; }
    }
}