﻿using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Net;
using Microsoft.AspNetCore;
using Microsoft.AspNetCore.Hosting;
using Twitch.Logging.Client.Util;
using Twitch.Shared.Model;

namespace Twitch.AuditLogService.Web
{
    // Justification: Too low-level to feasibly test.
    [ExcludeFromCodeCoverage]
    public class Program
    {
        public static void Main(string[] args)
        {
            CreateWebHostBuilder(args).Build().Run();
        }

        public static IWebHostBuilder CreateWebHostBuilder(string[] args)
        {
            ServiceInfo.Initialize("AuditLogService");
            return WebHost.CreateDefaultBuilder()
                .UseContentRoot(Directory.GetCurrentDirectory())
                .UseKestrel(options =>
                {
#if DEBUG
                    options.Listen(IPAddress.Loopback, 5012);                    
                    options.Listen(IPAddress.Loopback, 8443,
                        listenOptions => { listenOptions.UseHttps("testCert.pfx", "testPassword"); });
#else
                    options.Listen(IPAddress.Loopback, 5000);
#endif
                })
                .ConfigureTwitchLogging()
                .UseStartup<Startup>();
        }    
    }
}
