﻿using System.Collections.Generic;
using System.Threading.Tasks;
using JetBrains.Annotations;
using Twitch.AuditLogService.ChangeLog.Models;

namespace Twitch.AuditLogService.ChangeLog
{
    public interface IChangeLogSearchManager
    {
        Task<bool> IndexAsync(ChangeLogElasticEntry item);
        Task<IReadOnlyCollection<ChangeLogElasticEntry>> SearchAsync(ChangeLogSearch searchCriteria, int pageSize);
        Task<Dictionary<string, Dictionary<string, long>>> GetTermFiltersAsync([CanBeNull]ChangeLogSearch searchCriteria);
    }
}