﻿// palldavi: disable CA1819 Properties should not return arrays - this is a DTO
#pragma warning disable CA1819

using Nest;
using Twitch.ElasticSearch;

namespace Twitch.AuditLogService.ChangeLog.Models
{
    [CloudSearchModel(IndexTypeName = "change-log", UseDefaultIndex = false, AutoCreateIndex = false, QueryCacheEnabled = true, ShardCount = 2, TemplateVersion = 1)]
    [ElasticsearchType(IdProperty = "Id", Name = "changeLog")]
    public class ChangeLogElasticEntry
    {
        /// <summary>
        /// Unique Id generated for this entry.
        /// </summary>
        [Keyword]
        public string Id { get; set; }

        /// <summary>
        /// The unix timestamp when the event happened.
        /// </summary>
        [Date]
        public long Timestamp { get; set; }

        /// <summary>
        /// The username of the user who issued the command.
        /// </summary>
        public string Username { get; set; }

        /// <summary>
        /// The name of the machine (or cluster, or system) being targeted.
        /// </summary>
        [Text]
        public string Target { get; set; }

        /// <summary>
        /// The hostname of the machine that issued the command.
        /// </summary>
        public string Source { get; set; }

        /// <summary>
        /// The command that was executed.
        /// </summary>
        public string Command { get; set; }

        /// <summary>
        /// Collection of event categories.
        /// </summary>
        [Keyword]
        public string[] Categories { get; set; }

        /// <summary>
        /// Criticality of the event.
        /// </summary>
        [Keyword]
        public int Criticality { get; set; }

        /// <summary>
        /// Description of the event.
        /// </summary>
        [Text]
        public string Description { get; set; }

        /// <summary>
        /// Additional event data.
        /// </summary>
        [Text]
        public string AdditionalData { get; set; }
    }
}
