﻿using Nest;
using Twitch.ElasticSearch.Extensions;
using Twitch.ElasticSearch.Search;

namespace Twitch.AuditLogService.ChangeLog.Models
{
    public class ChangeLogSearch
    {
        public ScrollingSearchFilter SearchFilter { get; set; }

        // Filters
        public ChangeLogSearchFilter Filter { get; set; }
        
        // Queries
        public ChangeLogSearchQuery Query { get; set; }

        public QueryContainer GetQuery(QueryContainerDescriptor<ChangeLogElasticEntry> builder)
        {
            return
                builder.AddTermsFilter(x => x.Username.Suffix("keyword"), Filter?.Username, ChangeLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Source.Suffix("keyword"), Filter?.Source, ChangeLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Categories, Filter?.Categories, ChangeLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Criticality, Filter?.Criticality)

                && builder.AddMatchQuery(x => x.Username, Query?.Username)
                && builder.AddMatchQuery(x => x.Source, Query?.Source)
                && builder.AddMatchQuery(x => x.Target, Query?.Target)
                && builder.AddMatchQuery(x => x.Command, Query?.Command)
                && builder.AddMatchQuery(x => x.Description, Query?.Description)
                && builder.AddMatchQuery(x => x.AdditionalData, Query?.AdditionalData);
        }
    }
}