﻿using System.Collections.Generic;
using System.Threading.Tasks;
using JetBrains.Annotations;
using Twitch.AuditLogService.Models;

namespace Twitch.AuditLogService
{
    public interface IAuditLogSearchManager
    {
        Task<bool> IndexAsync(AuditLogElasticEntry item);
        Task<IReadOnlyCollection<AuditLogElasticEntry>> SearchAsync(AuditLogSearch searchCriteria, int pageSize);
        Task<Dictionary<string, Dictionary<string, long>>> GetTermFiltersAsync([CanBeNull]AuditLogSearch searchCriteria);
    }
}