﻿using Nest;
using Twitch.ElasticSearch.Extensions;
using Twitch.ElasticSearch.Search;

namespace Twitch.AuditLogService.Models
{
    public class AuditLogSearch
    { 
        public ScrollingSearchFilter SearchFilter { get; set; }
        // Filters
        public AuditLogSearchFilter Filter { get; set; }

        // Queries
        public AuditLogSearchQuery Query { get; set; }

        public QueryContainer GetQuery(QueryContainerDescriptor<AuditLogElasticEntry> builder)
        {
            return
                builder.AddTermsFilter(x => x.TokenId, Filter?.TokenId, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Name, Filter?.Name, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Email, Filter?.Email, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.AmazonUID, Filter?.AmazonUID, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Service, Filter?.Service, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Handler.Suffix("keyword"), Filter?.Handler, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Uri.Suffix("keyword"), Filter?.Uri, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.Method, Filter?.Method, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.ResponseCode, Filter?.ResponseCode)
                && builder.AddTermsFilter(x => x.Canceled, Filter?.Canceled)
                && builder.AddTermsFilter(x => x.Exception, Filter?.Exception)
                && builder.AddTermsFilter(x => x.ActionType, Filter?.ActionType, AuditLogSearchManager.EmptyFilterString)
                && builder.AddTermsFilter(x => x.OperationName, Filter?.OperationName, AuditLogSearchManager.EmptyFilterString)

                && builder.AddMatchQuery(x => x.Manager, Query?.Manager)
                && builder.AddMatchQuery(x => x.Title, Query?.Title)
                && builder.AddMatchQuery(x => x.Department, Query?.Department)
                && builder.AddMatchQuery(x => x.UserAgent, Query?.UserAgent)
                && builder.AddMatchQuery(x => x.Handler, Query?.Handler)
                && builder.AddMatchQuery(x => x.Uri, Query?.Uri)
                && builder.AddMatchQuery(x => x.Data, Query?.Data)
                && builder.AddMatchQuery(x => x.RolesAllowed, Query?.RolesAllowed);
        }
    }
}