﻿using System;

namespace Twitch.AuditLogService.Runner
{
    public class ChangeLogEntry
    {
        public ChangeLogEntry(RawChangeLogEntry raw)
        {
            Id = Guid.NewGuid().ToString("N");
            Timestamp = DateTimeOffset.UtcNow.ToUnixTimeSeconds();
            Username = raw.username;
            Target = raw.target;
            Source = raw.source;
            Command = raw.command;
            Categories = raw.category?.Split(',', StringSplitOptions.RemoveEmptyEntries);
            Criticality = raw.criticality;
            Description = raw.description;
            AdditionalData = raw.additional_data;
        }

        public string Id { get; set; }
        public long Timestamp { get; set; }
        public string Username { get; set; }
        public string Target { get; set; }
        public string Source { get; set; }
        public string Command { get; set; }
        public string[] Categories { get; set; }
        public int Criticality { get; set; }
        public string Description { get; set; }
        public string AdditionalData { get; set; }
    }

    public class RawChangeLogEntry
    {
        public string category { get; set; }
        public string username { get; set; }
        public string command { get; set; }
        public string description { get; set; }
        public int criticality { get; set; }
        public string source { get; set; }
        public int event_id { get; set; }
        public long unix_timestamp { get; set; }
        public string additional_data { get; set; }
        public string target { get; set; }
    }
}