﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Threading.Tasks;
using Amazon;
using Amazon.Extensions.NETCore.Setup;
using Amazon.SimpleNotificationService;
using Newtonsoft.Json;
using Twitch.AuditLogClient.Models;

namespace Twitch.AuditLogService.Runner
{
    class Program
    {
        public const string TopicArn = "arn:aws:sns:us-west-2:523910602058:audit_log_ingress";
        public const int Workers = 100;
        public const int IterationsPerWorker = 1_000;

        static async Task Main(string[] args)
        {
            var awsOptions = new AWSOptions { Profile = "assume-cpe-tools-shadow", Region = RegionEndpoint.USWest2 };

            var snsClient = awsOptions.CreateServiceClient<IAmazonSimpleNotificationService>();
            var content = File.ReadAllText(@"changelog_sample_payload.json");

            var entries = JsonConvert.DeserializeObject<RawChangeLogEntry[]>(content);

            Console.WriteLine($"Writing {entries.Length} changelog entries");
            foreach (var rawChangeLogEntry in entries)
            {
                var entry = new ChangeLogEntry(rawChangeLogEntry);
                await snsClient.PublishAsync(TopicArn, JsonConvert.SerializeObject(entry));
            }
            Console.WriteLine($"Done writing {entries.Length} changelog entries");

            return;

            Console.WriteLine($"Starting {Workers} Workers submitting {IterationsPerWorker} messages each for a total of {Workers*IterationsPerWorker} messages.");

            var watch = Stopwatch.StartNew();
            var tasks = new Task[Workers];
            for (int i = 0; i < Workers; i++)
            {
                //tasks[i] = SubmitToSns(i, snsClient);
                tasks[i] = SubmitToSns(i, awsOptions.CreateServiceClient<IAmazonSimpleNotificationService>());
            }

            await Task.WhenAll(tasks);
            
            Console.WriteLine($"Submitted {Workers * IterationsPerWorker} messages in {watch.Elapsed}");
        }

        public static async Task SubmitToSns(int workerId, IAmazonSimpleNotificationService snsClient)
        {
            for (int i = 1; i <= IterationsPerWorker; i++)
            {

                var entry = new AuditLogEntry("AuditLogTestRunner")
                {
                    ActionType = AuditLogClient.Util.AuditLogActionType.Read,
                    Canceled = false,
                    Data = $"testData thread iteration {i}/{IterationsPerWorker}",
                    DataChanges = new Dictionary<string, AuditLogDataChange> { { "TestChange", new AuditLogDataChange("Before") { After = "After", Valid = true } } },
                    Exception = false,
                    Name = "Felix Kastner (fkastne)",
                    Email = "fkastne@twitch.tv",
                    AmazonUID = "fkastne",
                    Manager = "cn=Adrian Luff,ou=Users,dc=justin,dc=tv",
                    Title = "Software Engineer",
                    Department = "Client Platforms_1T",
                    ClientIP = "127.0.0.1",
                    TokenId = "2229d367-7f1a-40b3-8cc7-97608885eda6",
                    UserAgent = "AuditLogTestRunner/1.0",
                    Handler = "Twitch.AuditLogTestRunner.Web.Controllers.SearchController.Search (Twitch.AuditLogService.Runner)",
                    Uri = "/search",
                    Method = "POST",
                    RolesAllowed = "",
                    ResponseCode = 200,
                    OperationName = "Search"
                };
                await snsClient.PublishAsync(TopicArn, JsonConvert.SerializeObject(entry));
            }
            Console.WriteLine($"Worker {workerId} is done.");
        }
    }
}
