#!/bin/bash

function usage {
    echo "Requests *.twitch.tv in ACM given a region"
    echo "request_cert -r REGION (-h)"
}

while test $# != 0
do
    case "$1" in
    -r) shift; REGION=$1 ;;
    -h) usage && exit 0;;
    esac
    shift
done

if [ -z $REGION ]; then
    usage
    exit 0
fi

TOKEN=$(echo $REGION | sed 's/-//g')
echo "Running: aws acm request-certificate --domain-name "*.twitch.tv" --idempotency ${TOKEN} --region ${REGION}"
aws acm request-certificate --domain-name "*.twitch.tv" --idempotency $TOKEN --region $REGION
