provider "aws" {
  region = "${var.region}"
  profile = "${var.account}"
}

data "template_file" "constants-stack-template" {
  template = "${file("../../templates/constants_stack.yaml")}"
}

resource "aws_cloudformation_stack" "networking-constants-stack" {
  name = "${var.stack_name}"
  template_body = "${data.template_file.constants-stack-template.rendered}"

  parameters {
    VpcId = "${data.terraform_remote_state.upstream.vpc_id}"
    SgId = "${data.terraform_remote_state.upstream.twitch_subnets_sg}"
    PrivateSubnetA = "${data.terraform_remote_state.upstream.service_a}"
    PrivateSubnetB = "${data.terraform_remote_state.upstream.service_b}"
    PrivateSubnetC = "${data.terraform_remote_state.upstream.service_c}"
    PublicSubnetA = "${data.terraform_remote_state.upstream.public_a}"
    PublicSubnetB = "${data.terraform_remote_state.upstream.public_b}"
    PublicSubnetC = "${data.terraform_remote_state.upstream.public_c}"
  }

  capabilities = ["CAPABILITY_IAM"]
}