#!/bin/zsh -ex
# Generates requirements.txt with all transitive dependencies pinned based on requirements-imported.txt.
# Only update requirements-imported manually to bump a version or add a new import.

cd $(dirname $0)/..

for lambda in `ls lambda`
do
    [[ -n $lambda ]] || exit 1
    lambda=lambda/$lambda
    [[ -d $lambda && -f $lambda/requirements-imported.txt ]] || continue

    [[ -d $lambda/venv ]] && rm -rf $lambda/venv
    virtualenv --python python2.7 $lambda/venv
    $lambda/venv/bin/pip install -r $lambda/requirements-imported.txt
    echo "# Generated from requirements-imported.txt, see scripts/$(basename $0)" > $lambda/requirements.txt
    $lambda/venv/bin/pip freeze >> $lambda/requirements.txt
    rm -rf $lambda/venv
done