package cursors

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestClientCursorString(t *testing.T) {
	sortKey := "name"
	sortOrder := "ASC"
	lastSortValue := "foo"
	lastRowID := "2"
	primaryKey := "id"
	c := Cursor{sortKey, sortOrder, lastSortValue, lastRowID, primaryKey}
	pc, err := Parse(c.String())
	assert.NoError(t, err)
	assert.Equal(t, c, pc)
}

func TestParseCursor(t *testing.T) {
	cStr := "bmFtZQ==~QVND~Zm9v~Mg==~aWQ="
	c, err := Parse(cStr)
	assert.NoError(t, err)
	assert.Equal(t, "2", c.LastRowID)
	assert.Equal(t, "name", c.SortKey)
	assert.Equal(t, "foo", c.LastSortValue)
	assert.Equal(t, "ASC", c.SortOrder)
	assert.Equal(t, "id", c.PrimaryKey)
}

func TestParseInvalidBase64(t *testing.T) {
	cStr := "lul~lul~lul~lul~lul"
	c, err := Parse(cStr)
	assert.Equal(t, Cursor{}, c)
	assert.EqualError(t, err, "illegal base64 data at input byte 0")
}

func TestParseEmptyCursor(t *testing.T) {
	cStr := ""
	c, err := Parse(cStr)
	assert.Equal(t, Cursor{}, c)
	assert.EqualError(t, err, "Cannot parse empty cursor")
}

func TestParseIncompleteCursor(t *testing.T) {
	cStr := "bmFtZQ==~QVND~Zm9v~aWQ="
	c, err := Parse(cStr)
	assert.Equal(t, Cursor{}, c)
	assert.EqualError(t, err, "Invalid cursor, could not parse: bmFtZQ==~QVND~Zm9v~aWQ=")
}
