# History Service Admin Scripts

Adminstrative Scripts for [history-service] and [history-worker].

## Usage

Install via go tooling.

```
go get code.justin.tv/foundation/history-admin
```

### Dumping audits

You must be able to assume
`arn:aws:iam::958416494912:role/history-v2-prod-read`. See the
[history-service terraform].

```
history-admin dump -userid geoffcha -start-date 2017-01-01 -end-date 2017-02-01 > out.csv
```

### Deleting Dynamo Key via Query

```
history-admin dump-ids -action stop_watching > ids.txt
history-admin delete-ids < ids.txt
```

## Development

Unit tests can be run with the `-short` flag.

```
go test -short ./...
```

Integration tests require [henshin] to be installed to grab testing credentials
from sandstorm.

```
eval $(henshin e)
go test ./...
eval $(henshin d)
```

[henshin]: https://git-aws.internal.justin.tv/geoffcha/henshin
[history-service]: https://git-aws.internal.justin.tv/foundation/history-service
[history-worker]: https://git-aws.internal.justin.tv/foundation/history-worker
[history-service terraform]: https://git-aws.internal.justin.tv/foundation/history-service/blob/dev/terraform/production/app.tf#L19
