package audit

import (
	"code.justin.tv/foundation/history-admin/internal/jsonutil"
	"code.justin.tv/foundation/history.v2/historyin"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

// Audit represents an audit event
type Audit struct {
	UUID         string                `json:"uuid"`
	Action       string                `json:"action"`
	UserType     string                `json:"user_type"`
	UserID       string                `json:"user_id"`
	ResourceType string                `json:"resource_type"`
	ResourceID   string                `json:"resource_id"`
	Description  string                `json:"description"`
	ExpiredAt    jsonutil.Time         `json:"expired_at,omitempty"`
	CreatedAt    jsonutil.Time         `json:"created_at"`
	Expiry       jsonutil.Duration     `json:"expiry,omitempty"`
	Changes      []historyin.ChangeSet `json:"changes"`
}

// Key returns the dynamodb key
func (a Audit) Key() map[string]*dynamodb.AttributeValue {
	return map[string]*dynamodb.AttributeValue{
		"uuid": {S: aws.String(a.UUID)},
	}
}
