package audit

import (
	"context"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestClientIntegration(t *testing.T) {
	if testing.Short() {
		t.Skip()
	}

	client := &Client{
		Environment:   "staging",
		ScanBatchSize: 10,
	}

	t.Run("test single item", func(t *testing.T) {
		ctx, cancel := context.WithTimeout(context.Background(), 30*time.Second)
		defer cancel()

		items := make([]*Audit, 0)
		err := client.ScanAudits(ctx, ScanLimit(1, func(a *Audit) bool {
			items = append(items, a)
			return true
		}))

		require.NoError(t, err)
		assert.Len(t, items, 1)

		for _, item := range items {
			assert.NotEmpty(t, item.UUID)
			assert.NotEmpty(t, item.Action)
		}
	})
}
