package audit

import (
	"context"

	"github.com/aws/aws-sdk-go/service/dynamodb"
)

// deleteBatchStream is a stream of audits
type deleteBatchStream struct {
	IDStream IDStream
	Size     int
}

func (dbs *deleteBatchStream) Next(ctx context.Context) (batch []*dynamodb.WriteRequest, last bool) {
	for {
		if len(batch) >= dbs.Size {
			return batch, false
		}

		id, last := dbs.IDStream.Next(ctx)
		if len(id) > 0 {
			batch = append(batch, &dynamodb.WriteRequest{
				DeleteRequest: &dynamodb.DeleteRequest{Key: Audit{UUID: id}.Key()},
			})
		}

		if last {
			return batch, true
		}
	}
}
