package audit

import (
	"context"
	"io"

	uuid "github.com/satori/go.uuid"
)

type arrayIDStream struct {
	IDs []string
}

func (a *arrayIDStream) Next(context.Context) (id string, last bool) {
	if len(a.IDs) == 0 {
		return "", true
	}

	id, a.IDs = a.IDs[0], a.IDs[1:]
	return id, len(a.IDs) == 0
}

// ReaderIDStream reads ids from a byte stream
type ReaderIDStream struct {
	Reader io.Reader
}

// Next implements IDStream
func (r *ReaderIDStream) Next(context.Context) (id string, last bool) {
	out := make([]byte, 16)
	if _, err := io.ReadFull(r.Reader, out); err != nil {
		return "", true
	}

	if id, err := uuid.FromBytes(out); err == nil {
		return id.String(), last
	}

	return "", last
}
