package audit

import (
	"bytes"
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestReaderIDStream(t *testing.T) {
	t.Run("exactly one id", func(t *testing.T) {
		ids := &ReaderIDStream{bytes.NewBuffer([]byte("abcdefghabcdefgh"))}

		var (
			id   string
			last bool
		)

		id, last = ids.Next(context.Background())
		assert.Equal(t, "61626364-6566-6768-6162-636465666768", id)
		assert.False(t, last)

		id, last = ids.Next(context.Background())
		assert.Empty(t, id)
		assert.True(t, last)

		id, last = ids.Next(context.Background())
		assert.Empty(t, id)
		assert.True(t, last)
	})

	t.Run("less than one id", func(t *testing.T) {
		ids := &ReaderIDStream{bytes.NewBuffer([]byte("abcdefghabcdefg"))}

		var (
			id   string
			last bool
		)

		id, last = ids.Next(context.Background())
		assert.Empty(t, id)
		assert.True(t, last)
	})
}
