package audit

import (
	"sync"
)

type pool struct {
	Size     int
	initSync sync.Once
	execChan chan interface{}
}

func (p *pool) init() {
	p.initSync.Do(func() {
		if p.Size == 0 {
			p.Size = 1
		}
		p.execChan = make(chan interface{}, p.Size)
	})
}

func (p *pool) Do(fn func()) {
	p.init()

	p.execChan <- nil
	go func() {
		fn()
		<-p.execChan
	}()
}
