package audit

// ScanLimit a ScanAuditsHandler to n items
func ScanLimit(nLimit int, h ScanAuditsHandler) ScanAuditsHandler {
	nCalls := 0
	return func(a *Audit) bool {
		nCalls++
		if nCalls > nLimit {
			return false
		}
		return h(a)
	}
}
