package jsonutil

import (
	"encoding/json"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestTime(t *testing.T) {
	t.Run("marshal", func(t *testing.T) {
		tNow := time.Now().Truncate(time.Nanosecond)

		marshalled, err := json.Marshal(Time(tNow))
		require.NoError(t, err)

		var unMarshalled Time
		require.NoError(t, json.Unmarshal(marshalled, &unMarshalled))
		assert.Equal(t, tNow.UTC(), time.Time(unMarshalled), "unmarshals and strips locale")
	})
}
