package main

import (
	"context"
	"flag"
	"os"

	"code.justin.tv/foundation/history-admin/historycmd"
	"github.com/google/subcommands"
	"github.com/sirupsen/logrus"
)

func main() {
	baseCmd := &historycmd.BaseCmd{Logger: logrus.New()}
	flag.StringVar(&baseCmd.Environment, "env", "prod", "one of 'staging' or 'prod'")

	subcommands.Register(subcommands.HelpCommand(), "")
	subcommands.Register(subcommands.FlagsCommand(), "")
	subcommands.Register(subcommands.CommandsCommand(), "")

	subcommands.Register(&historycmd.DumpIDsCmd{BaseCmd: baseCmd}, "history")
	subcommands.Register(&historycmd.DeleteIDsCmd{BaseCmd: baseCmd}, "history")
	subcommands.Register(&historycmd.SyncESCmd{BaseCmd: baseCmd}, "history")
	subcommands.Register(&historycmd.DumpCmd{BaseCmd: baseCmd}, "history")
	subcommands.Register(&historycmd.HistCmd{BaseCmd: baseCmd}, "history")
	subcommands.Register(&historycmd.DumpActionCmd{BaseCmd: baseCmd}, "history")

	flag.Parse()

	os.Exit(int(subcommands.Execute(context.Background())))
}
