resource "aws_iam_role" "admin" {
  name               = "${local.prefix}"
  description        = "role to run foundation/history-admin scripts"
  assume_role_policy = "${data.aws_iam_policy_document.admin-arp.json}"
}

data "aws_iam_policy_document" "admin-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "AWS"
      identifiers = ["${var.admin_arns}"]
    }
  }
}

resource "aws_iam_role_policy" "admin" {
  role   = "${aws_iam_role.admin.id}"
  policy = "${data.aws_iam_policy_document.admin-rp.json}"
}

data "aws_iam_policy_document" "admin-rp" {
  statement {
    actions = [
      "dynamodb:BatchWriteItem",
      "dynamodb:Scan",
    ]

    resources = [
      "${data.aws_dynamodb_table.history.arn}",
    ]
  }
}
