resource "aws_instance" "admin" {
  ami                  = "${data.aws_ami.amazon_linux.image_id}"
  instance_type        = "c5.xlarge"
  iam_instance_profile = "${aws_iam_instance_profile.admin.name}"
  key_name             = "history-${local.env}-ssh"
  availability_zone    = "${local.ec2_availability_zone}"
  subnet_id            = "${data.aws_subnet.twitch.id}"
  security_groups      = ["${data.aws_security_group.twitch_subnets.id}"]

  root_block_device {
    volume_size = "128"
  }

  tags {
    Name = "${local.resource_prefix}"
  }
}

data "aws_ami" "amazon_linux" {
  most_recent = true

  filter {
    name   = "owner-alias"
    values = ["amazon"]
  }

  filter {
    name   = "name"
    values = ["amzn-ami-hvm-*"]
  }
}

data "aws_security_group" "twitch_subnets" {
  name = "twitch_subnets"
}

data "aws_subnet" "twitch" {
  availability_zone = "${local.ec2_availability_zone}"

  filter {
    name   = "tag:Name"
    values = ["Private - A"]
  }
}

resource "aws_iam_instance_profile" "admin" {
  name = "${local.resource_prefix}-ec2"
  role = "${aws_iam_role.admin-ec2.name}"
}

resource "aws_iam_role" "admin-ec2" {
  name               = "${local.resource_prefix}-ec2"
  description        = "role to run foundation/history-admin scripts"
  assume_role_policy = "${data.aws_iam_policy_document.admin-ec2-arp.json}"
}

data "aws_iam_policy_document" "admin-ec2-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type = "Service"

      identifiers = [
        "ec2.amazonaws.com",
      ]
    }
  }
}

resource "aws_iam_role_policy" "admin-ec2" {
  role   = "${aws_iam_role.admin-ec2.id}"
  policy = "${data.aws_iam_policy_document.admin-ec2-rp.json}"
}

data "aws_iam_policy_document" "admin-ec2-rp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${module.history-admin.role_arn}",
      "arn:aws:iam::958416494912:role/history-v2-prod-read",
    ]
  }

  statement {
    actions = [
      "s3:Put*",
    ]

    resources = [
      "${aws_s3_bucket.results.arn}/*",
    ]
  }
}
