resource "aws_s3_bucket" "results" {
  bucket = "twitch-history-aws-results"
  acl    = "private"
}

resource "aws_s3_bucket_policy" "results-bp" {
  bucket = "${aws_s3_bucket.results.id}"
  policy = "${data.aws_iam_policy_document.results-bp.json}"
}

data "aws_iam_policy_document" "results-bp" {
  statement {
    actions = [
      "s3:ListBucket",
    ]

    effect = "Allow"

    resources = [
      "${aws_s3_bucket.results.arn}",
    ]

    principals {
      type        = "AWS"
      identifiers = ["${local.data_infra_allowed_arns}"]
    }
  }

  statement {
    actions = [
      "s3:Get*",
    ]

    resources = [
      "${aws_s3_bucket.results.arn}/data-infra/*",
    ]

    principals {
      type        = "AWS"
      identifiers = ["${local.data_infra_allowed_arns}"]
    }
  }
}
