provider "aws" {
  version             = "~> 1.4"
  region              = "us-west-2"
  profile             = "twitch-history-dev"
  allowed_account_ids = ["005087123760"]
}

# see https://git-aws.internal.justin.tv/sse/terraform-provider-sandstorm
provider "sandstorm" {}

module "history-admin" {
  source = "../modules/history-admin"

  env = "${local.env}"

  admin_arns = [
    "${aws_iam_user.jenkins.arn}",
  ]
}

data "aws_caller_identity" "current" {}

locals {
  account_id = "${data.aws_caller_identity.current.account_id}"
}
