package config

import "fmt"

// Config is the history stack configuration
type Config struct {
	DeliveryStreamName string
	AWSRegion          string
	RoleARN            string
}

var (
	stagingConfig = Config{
		DeliveryStreamName: "history-v2-staging",
		AWSRegion:          "us-west-2",
		RoleARN:            "arn:aws:iam::005087123760:role/history-v2-staging-ingest",
	}

	prod = Config{
		DeliveryStreamName: "history-v2-prod",
		AWSRegion:          "us-west-2",
		RoleARN:            "arn:aws:iam::958416494912:role/history-v2-prod-ingest",
	}
)

// Environment gets a config for an environment
func Environment(environment string) (Config, error) {
	switch environment {
	case "staging":
		return stagingConfig, nil
	case "":
		fallthrough
	case "prod":
		return prod, nil
	}
	return Config{}, fmt.Errorf("invalid history environment: %s", environment)
}
