package main

import (
	"context"
	"flag"
	"os"

	"code.justin.tv/foundation/history-edge/internal/deployutils/ecs"
	"github.com/google/subcommands"
	"github.com/sirupsen/logrus"
)

func main() {

	lgr := logrus.New()

	subcommands.Register(subcommands.HelpCommand(), "")
	subcommands.Register(subcommands.FlagsCommand(), "")
	subcommands.Register(subcommands.CommandsCommand(), "")

	subcommands.Register(&ecs.UpdateTaskDefCmd{
		Logger: lgr,
	}, "ecs")

	flag.Parse()

	os.Exit(int(subcommands.Execute(context.Background())))
}
