#!/bin/bash -e
set +x

[[ -z "$REPO" ]] && echo '$REPO is required' && exit 1

export PYTHONUNBUFFERED=1
set -x

BASE_STAGING_ECR_URL="005087123760.dkr.ecr.us-west-2.amazonaws.com/history-edge-staging"
BASE_PROD_ECR_URL="958416494912.dkr.ecr.us-west-2.amazonaws.com/history-edge-prod"

case $ENVIRONMENT in
  "staging")
    export ECR_HISTORY_IMAGE_URL="$BASE_STAGING_ECR_URL:$GIT_COMMIT"
    ;;
  "prod")
    export ECR_HISTORY_IMAGE_URL="$BASE_PROD_ECR_URL:$GIT_COMMIT"
    ;;
  *)
    echo "Invalid Enviroment: $ENVIRONMENT"
    exit 1
    ;;
esac

export HISTORY_IMAGE_URL="$REPO/$ENVIRONMENT:$GIT_COMMIT"

docker pull $HISTORY_IMAGE_URL
docker tag $HISTORY_IMAGE_URL $ECR_HISTORY_IMAGE_URL

aws ecr get-login --no-include-email --region us-west-2 | bash
docker push $ECR_HISTORY_IMAGE_URL

./bin/deploy ecs -env $ENVIRONMENT -git-commit $GIT_COMMIT
