resource "aws_iam_role" "task" {
  name = "${local.resource_prefix}-task"

  assume_role_policy = "${data.aws_iam_policy_document.task-arp.json}"
}

data "aws_iam_policy_document" "task-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "Service"
      identifiers = ["ecs-tasks.amazonaws.com"]
    }

    principals {
      type        = "AWS"
      identifiers = ["${local.root_arn}"]
    }
  }
}

resource "aws_iam_role_policy_attachment" "execution" {
  role       = "${aws_iam_role.execution.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AmazonECSTaskExecutionRolePolicy"
}

# Execution IAM role for ECS Container
resource "aws_iam_role" "execution" {
  name               = "${local.resource_prefix}-execution"
  assume_role_policy = "${data.aws_iam_policy_document.execution.json}"
}

data "aws_iam_policy_document" "execution" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "Service"
      identifiers = ["ecs-tasks.amazonaws.com", "ecs.amazonaws.com"]
    }
  }
}

# Deploy to ECR IAM
resource "aws_iam_role" "deploy" {
  name               = "${local.resource_prefix}-deploy"
  assume_role_policy = "${data.aws_iam_policy_document.deploy-arp.json}"
}

data "aws_iam_policy_document" "deploy-arp" {
  statement = {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type = "AWS"

      identifiers = [
        "${aws_iam_user.jenkins.arn}",
      ]
    }
  }
}

resource "aws_iam_role_policy" "deploy" {
  role   = "${aws_iam_role.deploy.id}"
  policy = "${data.aws_iam_policy_document.deploy-p.json}"
}

data "aws_iam_policy_document" "deploy-p" {
  statement {
    actions = [
      "ecs:RegisterTaskDefinition",
      "ecs:UpdateService",
      "ecr:DescribeRepositories",
      "ecr:GetAuthorizationToken",
    ]

    resources = [
      "*",
    ]
  }

  statement {
    actions = [
      "ecr:*",
    ]

    resources = [
      "${aws_ecr_repository.edge.arn}",
    ]
  }

  statement {
    actions = [
      "iam:PassRole",
    ]

    resources = [
      "${aws_iam_role.task.arn}",
      "${aws_iam_role.execution.arn}",
    ]
  }
}

resource "aws_iam_user" "jenkins" {
  name = "${local.resource_prefix}-jenkins"
  path = "/"
}

data "aws_iam_policy_document" "jenkins-p" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${aws_iam_role.deploy.arn}",
    ]

    effect = "Allow"
  }

  statement {
    actions = [
      "ecr:*",
    ]

    resources = [
      "*",
    ]

    effect = "Allow"
  }
}

resource "aws_iam_user_policy" "jenkins" {
  name   = "${local.resource_prefix}-jenkins-policy"
  user   = "${aws_iam_user.jenkins.name}"
  policy = "${data.aws_iam_policy_document.jenkins-p.json}"
}
