resource "aws_lb" "edge" {
  name               = "${local.resource_prefix}-nlb"
  internal           = true
  load_balancer_type = "network"

  subnets = "${var.twitch_subnets}"

  tags = {
    Service     = "${local.resource_prefix}"
    Environment = "${var.environment}"
  }
}

# see https://github.com/terraform-providers/terraform-provider-aws/issues/636
resource "random_string" "target_name-suffix" {
  length  = 4
  special = false
}

resource "aws_lb_target_group" "edge" {
  name        = "${local.resource_prefix}-nlb-${random_string.target_name-suffix.result}"
  port        = "${local.lb_target_group_port}"
  protocol    = "TCP"
  vpc_id      = "${var.vpc_id}"
  target_type = "ip"

  lifecycle {
    create_before_destroy = true
  }

  tags {
    Name = "${local.resource_prefix}"
  }

  stickiness = []
}

resource "aws_lb_listener" "edge" {
  load_balancer_arn = "${aws_lb.edge.arn}"
  port              = "443"
  protocol          = "TLS"
  ssl_policy        = "ELBSecurityPolicy-TLS-1-2-2017-01"
  certificate_arn   = "${aws_acm_certificate.edge.arn}"

  default_action {
    target_group_arn = "${aws_lb_target_group.edge.arn}"
    type             = "forward"
  }

  depends_on = [
    "aws_lb_target_group.edge",
  ]
}
