variable "environment" {}
variable "vpc_id" {}
variable "region" {}

variable "twitch_security_groups" {
  type = "list"
}

variable "twitch_subnets" {
  type = "list"
}

variable "desired_count" {}

output "lb_dns_name" {
  value = "${aws_lb.edge.dns_name}"
}

data "aws_caller_identity" "current" {}

variable "domain_name" {}

locals {
  resource_prefix      = "history-edge-${var.environment}"
  aws_account_id       = "${data.aws_caller_identity.current.account_id}"
  root_arn             = "arn:aws:iam::${local.aws_account_id}:root"
  lb_target_group_port = 8000
}
