package configuration

import (
	"os"
	"testing"

	"github.com/stretchr/testify/suite"
)

type ConfigSuite struct {
	suite.Suite
}

func TestClient(t *testing.T) {
	suite.Run(t, &ConfigSuite{})
}

func (s *ConfigSuite) TestNoEnvironment() {
	err := os.Setenv("ENVIRONMENT", "")
	s.Require().NoError(err)
	env, err := Environment()
	s.Require().NoError(err)
	s.Assert().Equal(env, "development")
}

func (s *ConfigSuite) TestDummyEnvironment() {
	err := os.Setenv("ENVIRONMENT", "test")
	s.Require().NoError(err)
	env, err := Environment()
	s.Require().NoError(err)
	s.Assert().Equal(env, "test")
}
