# History API

## Endpoints

| Function                        | Method | Url          |
|---------------------------------|:------:|--------------|
| Search for audits               | GET    | `/v1/authed/audits` |
| Record an audit                 | POST   | `/v1/audits` |

## Endpoint Details

### GET /v1/authed/audits
e.g. [https://history.staging.us-west2.twitch.tv/v1/audits?action=update](http://history.staging.us-west2.twitch.tv/v1/audits?action=update)

This endpoint requires S2S access to `history-staging`.

This endpoint accepts the following query parameters to filter audit data:

| Parameter         | Description                          |
|-------------------|--------------------------------------|
| uuid              | UUID                                 |
| action            | Action                               |
| user_type         | User type                            |
| user_id           | User ID                              |
| resource_type     | Resource type                        |
| resource_id       | Resource ID                          |
| created_at_gt[e]  | Audits created after a certain time  |
| created_at_lt[e]  | Audits created before a certain time |
| attribute         | Attribute changed                    |
| old_value         | Old value of the field changed       |
| new_value         | New value of the field changed       |

Multiples or combinations of each are accepted. E.g. `/v1/audits?user_type=twitch_user&resource_id=10`

A successful GET request will return the following object with status 200 OK:

    {
      "audits": [
        {
          "uuid": "dbce7c0e-8d72-5c64-9568-ad56246d9602",
          "action": "update",
          "user_type": "twitch_user",
          "user_id": "1",
          "resource_type": "twitch_user",
          "resource_id": "1",
          "description": "example audit",
          "expired_at": "2018-02-18T00:18:29.325000000Z",
          "created_at": "2017-02-18T00:18:29.325000000Z",
          "changes": [
            {
              "attribute": "bio",
              "old_value": "this is my old bio",
              "new_value": "this is my new bio"
            }
          ]
        },
      ],
      "total_pages": 1
    }

### POST /v1/audits
This endpoint will record the contents of the request body as an audit, and requires that you pass in the header `Content-Type: application/json`. Fields accepted in the request body are listed below. Bolded fields are required.

| Field          | Description                     |
-----------------|---------------------------------|
| uuid           | v5 UUID                         |
| **action**     | Action                          |
| **user_type**  | User type                       |
| **user_id**    | User ID                         |
| resource_type  | Resource type                   |
| resource_id    | Resource ID                     |
| description    | Description (1024 chars max)    |
| **expiry**     | Expiry in seconds (must be > 0) |
| created_at     | Created at timestamp (ISO8601)  |
| changes        | List of changes                 |


`uuid` is generated for you if you are using the [Go](https://git-aws.internal.justin.tv/foundation/history-service/blob/master/client/history/history.go) or [Ruby](https://git-aws.internal.justin.tv/foundation/history-client-ruby) client. If you are POSTing manually (i.e. with `curl` or Postman), you will need to generate a `uuid` when you POST.

An example JSON body:

    {
      "uuid":"2b73a24e-8f60-52a6-8622-cac96066f0dd",
      "action":"update",
      "user_type":"twitch_user",
      "user_id":"40978508",
      "resource_type":"twitch_user",
      "resource_id":"40978508",
      "description":"",
      "expiry": 31622400,
      "created_at":"2017-02-04T11:30:40.018000000Z",
      "changes":[
        {
          "attribute": "login",
          "old_value": "old_login",
          "new_value": "new_login"
        }
      ]
    }

A successful POST request will return status 200 OK. A failed POST request will return 400 Bad Request.
